#!/usr/bin/env bash
set -euo pipefail
J="${1:-Tokra_Sovereign_PSR_envelope_public_nonbinding.json}"
jq -S -c '.payload' "$J" > /tmp/payload.canon.json
jq -r '.evidence.signature_b64' "$J" | base64 -d > /tmp/sig.bin
jq -r '.evidence.public_key_pem_b64' "$J" | base64 -d > /tmp/pub.pem
echo "Declared payload_sha256: $(jq -r '.evidence.payload_sha256|sub("^sha256:";"")' "$J")"
echo -n "Computed payload_sha256: "; sha256sum /tmp/payload.canon.json | awk '{print $1}'
openssl pkeyutl -verify -pubin -inkey /tmp/pub.pem -rawin -in /tmp/payload.canon.json -sigfile /tmp/sig.bin && echo "SIG_OK"
