# Tokra Sovereign — PSR (Envelope 1.1)

**File**: Tokra_Sovereign_PSR_envelope_20251021T070032Z.json  
**payload_sha256**: `27c377bd9800c31e3a805764ec0387ac3f3fc6228e534cfae4cc2d2d26369d48`  
**Public key fingerprint (SHA-256 DER)**: `f0017a4193439cdd0a8dd336576016c654397e63f04cc178428daf971fc35e07`

## Header
- Product: Tokra Sovereign
- PSR ID: tokra-psr-20251021T065321Z
- Generated (UTC): 2025-10-21T06:53:51Z
- Version: PSR-Envelope-1.1
- Scope: public_demo
- Assurance Level: A1
- Contact: info@tokra.ai
- Next Steps: Pilot/dashboard under NDA. Disclose full materials by hash-matching the commitments.
- Labels: public_non_binding=true

## Zero-Egress Window
- start_utc: 2025-10-21T06:53:21Z
- end_utc: 2025-10-21T06:53:51Z
- window_sec: 30
- egress_events: 0

## Isolation (aggregate, no IDs)
- interface_count: 15
- rx_bytes_total_delta: 21780
- tx_bytes_total_delta: 0
- method: aggregate_device_counters_no_identifiers

## Bench Claim
- mean_tps: ≈1789
- mean_latency_ms: ≈71.5
- workload_hint: prefill=512 gen=128 batch=32 seq_len=2048

## Resource Hints
- cpu_peak_pct: 3.8
- mem_max_mib: 4251

## Commitments (SHA-256)
- crypto_profile_commitment: sha256:a514bf1a123002089dd5a799228610211f72cefdcc13136143247671d40d2070
- policy_bundle_commitment: sha256:ec93f41b00bcdf2e343ed5c299669330a24dcf15535258958d40c020cbe8f4c0
- governance_summary_commitment: sha256:629efc1b494fc94d6dbf85d3870373d20629003cb2ab413ef40aa57a3bacd78d
- training_envs_commitment: sha256:5e55efb5cda91cc6583e4e07569555d3a0797dc2e39e97efdda9dd4936d6b9cc
- model_registry_commitment: sha256:5ace372e8bc895e53d30c021bd8600a7bef2f8106de29b815b5c541d8b658272
- connectors_map_commitment: sha256:1c6787cf61aa123951be3c0b4b35509afacbd923d1d1aafda15cb8ce167268b7
- sbom_provenance_commitment: sha256:12c2f49d8cfcaa56148b2203fb59cad503a1a54ac17f866dbba89a2c138c3e91

### Commitments — short descriptions
- crypto_profile_commitment: Security & crypto primitives profile (params & modes) — existence proof only.
- policy_bundle_commitment: Runtime governance & egress policy bundle — existence proof only.
- governance_summary_commitment: Audit, retention and oversight summary — existence proof only.
- training_envs_commitment: Training environments summary (datasets/process envelopes) — existence proof only.
- model_registry_commitment: Model registry entries (IDs/versions/lineage) — existence proof only.
- connectors_map_commitment: Integration connectors map & allowlist — existence proof only.
- sbom_provenance_commitment: Supply-chain SBOM & provenance attestations — existence proof only.

## Evidence
- signature_type: Ed25519
- digest_alg: SHA-256
- payload_sha256: `27c377bd9800c31e3a805764ec0387ac3f3fc6228e534cfae4cc2d2d26369d48`
- signature_b64: DjIUBXAo6piDcoI3VICItJLEMUVxzaW5WatrdGHLHU7ozgXd…

## Verification (offline)
```bash
jq -S -c .payload Tokra_Sovereign_PSR_envelope_20251021T070032Z.json > /tmp/payload.canon.json
jq -r .evidence.signature_b64 Tokra_Sovereign_PSR_envelope_20251021T070032Z.json | base64 -d > /tmp/sig.bin
jq -r .evidence.public_key_pem_b64 Tokra_Sovereign_PSR_envelope_20251021T070032Z.json | base64 -d > /tmp/pub.pem
sha256sum /tmp/payload.canon.json
openssl pkeyutl -verify -pubin -inkey /tmp/pub.pem -rawin -in /tmp/payload.canon.json -sigfile /tmp/sig.bin && echo SIG_OK
```
